/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Bath 
**
** DESCRIPTION:	Bath Restoration Puzzle
**
**      AUTHOR:	Arthur Humphrey, from template of Adrian Francis
**
\******************************************************************************/

#ifndef BATH_H
#define BATH_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CBath : public IPuzzle
{
	friend class CPuzzle;

private:

	//class structures
	struct SSaveState
	{
	
	};

	//class data
	bool		m_bIsFilled;
	int				m_iProgress;

	//class methods
	//setup
	public:		CBath(void);
	public:		void Reset();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Advance(CVillager &Villager, const int iRef);
	public:		void Complete();

	// access
	public:		const bool IsRepaired() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CBath		Bath;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/